
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Transactions;
using System.Collections;
using System.Data;
using System.Text;
using System.Linq;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
using gov.va.med.vbecs.Common;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
    [TestFixture]
    public class DAL_PendingTestStatusTest : BaseTest
    {
        [Test]
        [Category("UC_115_AutomatedTesting")]
        public void GetPendingTestStatus_Pass()
        {
            using (TransactionScope scope = new TransactionScope())
            {
                // Arrange
                var pendingTestStatusList = Enum.GetValues(typeof(PendingTestStatus));
                var matchesFound = 0;

                //Act
                var dtPendingBloodUnitTest = UnitTestUtil.RunSQLGetDataTable("SELECT PendingTestStatusId FROM PendingTestStatus", false);

                foreach (PendingTestStatus enumStatus in pendingTestStatusList)
                {
                    foreach (DataRow drStatus in dtPendingBloodUnitTest.Rows)
                    {
                        int pendingStatusId;
                        if (int.TryParse(drStatus[0].ToString(), out pendingStatusId) &&
                            pendingStatusId == (int)enumStatus)
                        {
                            matchesFound++;
                        }
                    }
                }

                // Assert
                Assert.IsTrue(matchesFound == pendingTestStatusList.Length);
            }
        }
    }
}


#endif



